/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.pathmapper;

import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.ui.PHPPluginImages;
import com.aptana.ui.util.SWTUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org2.eclipse.php.internal.core.project.IIncludePathEntry;
import org2.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org2.eclipse.php.internal.debug.core.pathmapper.BestMatchPathComparator;
import org2.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org2.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIImages;

public class PathEntrySelectionDialog
extends TrayDialog {
    private static final Object[] EMPTY = new Object[0];
    private static final Object EXTERNAL_CONTAINER = new Object();
    private VirtualPath path;
    private PathEntry[] pathEntries;
    private PathEntry result;
    private VirtualPath ignorePathResult;
    private Font boldFont;
    protected Button selectMappingBtn;
    private TreeViewer entriesViewer;
    protected Button ignoreMappingBtn;
    private Text ignorePathText;
    private Button configurePathBtn;

    public PathEntrySelectionDialog(Shell shell, VirtualPath path, PathEntry[] pathEntries) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.path = path;
        this.pathEntries = pathEntries;
        if (!shell.isFocusControl()) {
            shell.setMinimized(false);
            shell.forceActive();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Path Mapping - Select Local Resource");
        newShell.setImage(PHPDebugUIImages.get("IMG_OBJ_PATH_MAPPING"));
    }

    protected Control createDialogArea(Composite parent) {
        FontData[] fontData;
        parent = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 2;
        this.initializeDialogUnits((Control)parent);
        FontData[] fontDataArray = fontData = parent.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData d = fontDataArray[n2];
            d.setStyle(1);
            ++n2;
        }
        this.boldFont = new Font(parent.getFont().getDevice(), fontData);
        this.selectMappingBtn = new Button(parent, 16);
        this.selectMappingBtn.setSelection(true);
        this.selectMappingBtn.setText("Select the local resource that matches the following server path:");
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.selectMappingBtn.setLayoutData((Object)layoutData);
        this.selectMappingBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = PathEntrySelectionDialog.this.selectMappingBtn.getSelection();
                PathEntrySelectionDialog.this.entriesViewer.getControl().setEnabled(enabled);
                PathEntrySelectionDialog.this.ignorePathText.setEnabled(!enabled);
                PathEntrySelectionDialog.this.configurePathBtn.setEnabled(!enabled);
                PathEntrySelectionDialog.this.validate();
            }
        });
        Label label = new Label(parent, 0);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.horizontalIndent = this.convertWidthInCharsToPixels(4);
        layoutData.verticalAlignment = 1;
        label.setLayoutData((Object)layoutData);
        label.setFont(this.boldFont);
        label.setText(this.path.toString());
        this.entriesViewer = new TreeViewer(parent, 2820);
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = this.convertHeightInCharsToPixels(1);
        layoutData.horizontalIndent = this.convertWidthInCharsToPixels(2);
        layoutData.heightHint = this.convertHeightInCharsToPixels(20);
        layoutData.widthHint = this.convertWidthInCharsToPixels(70);
        this.entriesViewer.getControl().setLayoutData((Object)layoutData);
        this.entriesViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.entriesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.entriesViewer.setSorter((ViewerSorter)new Sorter());
        this.entriesViewer.setInput((Object)this);
        this.entriesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PathEntrySelectionDialog.this.validate();
            }
        });
        this.entriesViewer.expandAll();
        this.ignoreMappingBtn = new Button(parent, 16);
        this.ignoreMappingBtn.setText("Do not map the following server path to a local resource:");
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.ignoreMappingBtn.setLayoutData((Object)layoutData);
        this.ignoreMappingBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = PathEntrySelectionDialog.this.ignoreMappingBtn.getSelection();
                PathEntrySelectionDialog.this.entriesViewer.getControl().setEnabled(!enabled);
                PathEntrySelectionDialog.this.ignorePathText.setEnabled(enabled);
                PathEntrySelectionDialog.this.configurePathBtn.setEnabled(enabled);
                PathEntrySelectionDialog.this.validate();
            }
        });
        this.ignorePathText = new Text(parent, 2056);
        this.ignorePathText.setEnabled(false);
        layoutData = new GridData(768);
        layoutData.horizontalIndent = this.convertWidthInCharsToPixels(2);
        layoutData.widthHint = this.convertWidthInCharsToPixels(70);
        this.ignorePathText.setLayoutData((Object)layoutData);
        this.ignorePathResult = this.path.clone();
        this.ignorePathText.setText(this.getIgnorePathString(this.ignorePathResult));
        this.configurePathBtn = new Button(parent, 8);
        this.configurePathBtn.setEnabled(false);
        this.configurePathBtn.setText("&Configure...");
        this.configurePathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurePathDialog dialog = new ConfigurePathDialog(PathEntrySelectionDialog.this.ignorePathResult);
                if (dialog.open() == 0) {
                    PathEntrySelectionDialog.this.ignorePathResult = dialog.getResult();
                    PathEntrySelectionDialog.this.ignorePathText.setText(PathEntrySelectionDialog.this.getIgnorePathString(PathEntrySelectionDialog.this.ignorePathResult));
                    PathEntrySelectionDialog.this.validate();
                }
            }
        });
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        okButton.setEnabled(false);
        this.createButton(parent, 1, "&Stop Debugger", false);
    }

    private String getIgnorePathString(VirtualPath path) {
        if (path.getSegmentsCount() == this.path.getSegmentsCount()) {
            return path.toString();
        }
        return path.toString() + path.getSeparatorChar() + '*';
    }

    public PathEntry getResult() {
        return this.result;
    }

    public VirtualPath getIgnoreResult() {
        return this.ignorePathResult;
    }

    protected void validate() {
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
        this.result = null;
        if (this.selectMappingBtn.getSelection()) {
            Object selectedElement = ((IStructuredSelection)this.entriesViewer.getSelection()).getFirstElement();
            if (selectedElement instanceof PathEntry) {
                okButton.setEnabled(true);
                this.result = (PathEntry)selectedElement;
            }
        } else {
            okButton.setEnabled(true);
        }
    }

    class ConfigurePathDialog
    extends Dialog {
        private VirtualPath result;
        private Text pathText;

        protected ConfigurePathDialog(VirtualPath path) {
            super(PathEntrySelectionDialog.this.getShell());
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.result = path;
        }

        public VirtualPath getResult() {
            return this.result;
        }

        protected Control createDialogArea(Composite parent) {
            parent = (Composite)super.createDialogArea(parent);
            this.initializeDialogUnits((Control)parent);
            this.getShell().setText("Select the Path");
            this.getShell().setImage(PHPDebugUIImages.get("IMG_OBJ_PATH_MAPPING"));
            TreeViewer treeViewer = new TreeViewer(parent, 2820);
            GridData layoutData = new GridData(1808);
            layoutData.heightHint = this.convertHeightInCharsToPixels(15);
            layoutData.widthHint = this.convertWidthInCharsToPixels(60);
            treeViewer.getControl().setLayoutData((Object)layoutData);
            treeViewer.setContentProvider((IContentProvider)new ContentProvider());
            treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            treeViewer.setInput((Object)0);
            treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Integer segmentNum = (Integer)((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (segmentNum != null) {
                        ConfigurePathDialog.this.result = PathEntrySelectionDialog.this.path.clone();
                        int i = PathEntrySelectionDialog.this.path.getSegmentsCount();
                        while (i > segmentNum) {
                            ConfigurePathDialog.this.result.removeLastSegment();
                            --i;
                        }
                        ConfigurePathDialog.this.pathText.setText(PathEntrySelectionDialog.this.getIgnorePathString(ConfigurePathDialog.this.result));
                    }
                }
            });
            this.pathText = new Text(parent, 2056);
            layoutData = new GridData(768);
            this.pathText.setLayoutData((Object)layoutData);
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.result.getSegmentsCount()));
            treeViewer.expandAll();
            return parent;
        }

        class ContentProvider
        implements ITreeContentProvider {
            ContentProvider() {
            }

            public Object[] getChildren(Object parentElement) {
                Integer segmentNum = (Integer)parentElement;
                if (segmentNum < PathEntrySelectionDialog.this.path.getSegmentsCount()) {
                    return new Object[]{segmentNum + 1};
                }
                return EMPTY;
            }

            public Object getParent(Object element) {
                Integer segmentNum = (Integer)element;
                if (segmentNum > 0) {
                    return segmentNum - 1;
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                Integer segmentNum = (Integer)element;
                return segmentNum < PathEntrySelectionDialog.this.path.getSegmentsCount();
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        class LabelProvider
        extends org.eclipse.jface.viewers.LabelProvider {
            private Map<String, Image> images = new HashMap<String, Image>();

            LabelProvider() {
            }

            public Image getImage(Object element) {
                Integer segmentNum = (Integer)element;
                if (segmentNum < PathEntrySelectionDialog.this.path.getSegmentsCount()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                String lastSegment = PathEntrySelectionDialog.this.path.getLastSegment();
                int idx = lastSegment.lastIndexOf(46);
                if (idx != -1) {
                    ImageData data;
                    String extension = lastSegment.substring(idx);
                    if (this.images.containsKey(extension)) {
                        return this.images.get(extension);
                    }
                    Program p = Program.findProgram((String)extension);
                    if (p != null && (data = p.getImageData()) != null) {
                        Image image = new Image((Device)Display.getDefault(), data);
                        this.images.put(extension, image);
                        return image;
                    }
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }

            public String getText(Object element) {
                Integer segmentNum = (Integer)element;
                return PathEntrySelectionDialog.this.path.getSegments()[segmentNum - 1];
            }

            public void dispose() {
                Iterator<Image> i = this.images.values().iterator();
                while (i.hasNext()) {
                    i.next().dispose();
                }
            }
        }
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == PathEntrySelectionDialog.this) {
                HashSet<Object> containers = new HashSet<Object>();
                PathEntry[] pathEntryArray = PathEntrySelectionDialog.this.pathEntries;
                int n = pathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PathEntry entry = pathEntryArray[n2];
                    if (entry.getType() == PathEntry.Type.INCLUDE_VAR || entry.getType() == PathEntry.Type.INCLUDE_FOLDER) {
                        containers.add(entry.getContainer());
                    } else if (entry.getType() == PathEntry.Type.WORKSPACE) {
                        containers.add(((IResource)entry.getContainer()).getProject());
                    }
                    ++n2;
                }
                return containers.toArray();
            }
            if (parentElement instanceof PathEntry) {
                return EMPTY;
            }
            HashSet<PathEntry> entries = new HashSet<PathEntry>();
            PathEntry[] pathEntryArray = PathEntrySelectionDialog.this.pathEntries;
            int n = pathEntryArray.length;
            int n3 = 0;
            while (n3 < n) {
                PathEntry entry = pathEntryArray[n3];
                if ((entry.getType() == PathEntry.Type.INCLUDE_VAR || entry.getType() == PathEntry.Type.INCLUDE_FOLDER) && entry.getContainer() == parentElement) {
                    entries.add(entry);
                } else if (entry.getType() == PathEntry.Type.WORKSPACE && ((IResource)entry.getContainer()).getProject() == parentElement) {
                    entries.add(entry);
                }
                ++n3;
            }
            return entries.toArray();
        }

        public Object getParent(Object element) {
            PathEntry entry;
            if (element == PathEntrySelectionDialog.this) {
                return null;
            }
            if (element instanceof PathEntry) {
                entry = (PathEntry)element;
                if (entry.getType() == PathEntry.Type.INCLUDE_VAR || entry.getType() == PathEntry.Type.INCLUDE_FOLDER) {
                    return entry.getContainer();
                }
                if (entry.getType() == PathEntry.Type.WORKSPACE) {
                    return ((IResource)entry.getContainer()).getProject();
                }
            }
            PathEntry[] pathEntryArray = PathEntrySelectionDialog.this.pathEntries;
            int n = pathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                entry = pathEntryArray[n2];
                if (entry.getType() == PathEntry.Type.INCLUDE_VAR || entry.getType() == PathEntry.Type.INCLUDE_FOLDER && entry.getContainer() == element) {
                    return entry;
                }
                if (entry.getType() == PathEntry.Type.WORKSPACE && ((IResource)entry.getContainer()).getProject() == element) {
                    return entry;
                }
                ++n2;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return !(element instanceof PathEntry);
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class LabelProvider
    implements ILabelProvider {
        private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        public Image getImage(Object element) {
            if (element instanceof IIncludePathEntry) {
                IIncludePathEntry includePathEntry = (IIncludePathEntry)element;
                if (includePathEntry.getEntryKind() == 4) {
                    return PHPPluginImages.get((String)"com.aptana.editor.php.epl.envvar_obj.gif");
                }
                return PHPPluginImages.get((String)"com.aptana.editor.php.epl.library_obj.gif");
            }
            if (element instanceof PathEntry) {
                return SWTUtils.getImage((AbstractUIPlugin)PHPEditorPlugin.getDefault(), (String)"/icons/full/obj16/php.png");
            }
            return this.workbenchLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element == EXTERNAL_CONTAINER) {
                return "External Files";
            }
            if (element instanceof IIncludePathEntry) {
                IIncludePathEntry includePathEntry = (IIncludePathEntry)element;
                return includePathEntry.getPath().toString();
            }
            if (!(element instanceof PathEntry)) {
                return this.workbenchLabelProvider.getText(element);
            }
            PathEntry entry = (PathEntry)element;
            String path = entry.getResolvedPath();
            if (entry.getType() == PathEntry.Type.WORKSPACE) {
                VirtualPath tmpPath = entry.getAbstractPath().clone();
                tmpPath.removeFirstSegment();
                path = tmpPath.toString();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
            }
            if (entry.getType() == PathEntry.Type.INCLUDE_FOLDER || entry.getType() == PathEntry.Type.INCLUDE_VAR) {
                IPath p;
                IIncludePathEntry includePathEntry = (IIncludePathEntry)entry.getContainer();
                String includePath = includePathEntry.getPath().toString();
                if (includePathEntry.getEntryKind() == 4 && (p = IncludePathVariableManager.instance().resolveVariablePath(path.toString())) != null) {
                    includePath = includePathEntry.getPath().toOSString();
                }
                if (includePath != null && path.startsWith(includePath)) {
                    path = path.substring(includePath.length());
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
            }
            return path;
        }

        public void addListener(ILabelProviderListener listener) {
            this.workbenchLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.workbenchLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.workbenchLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.workbenchLabelProvider.removeListener(listener);
        }
    }

    class Sorter
    extends ViewerSorter {
        private BestMatchPathComparator comparator;

        public Sorter() {
            this.comparator = new BestMatchPathComparator(PathEntrySelectionDialog.this.path);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof PathEntry && e2 instanceof PathEntry) {
                return this.comparator.compare((PathEntry)e1, (PathEntry)e2);
            }
            if (e1 == EXTERNAL_CONTAINER) {
                return 1;
            }
            if (e1 instanceof IResource) {
                return -1;
            }
            return 0;
        }
    }
}

